
set more off
quiet: do "INDIVIDUAL 2a. Prepare Variables TWM.do"

keep COUNTRY mazhab sunnimuslim shiamuslim

*======================================================
* Change Variable Labels
*======================================================

label variable mazhab "Mazhab"
label variable sunnimuslim "Is Sunni Muslim?"
label variable shiamuslim "Is Shia Muslim?"

label define mazhablab 1 "Sunni" 2 "Shia" 3 "Just Muslim" 4 "Others"
label values mazhab mazhablab

label define ismuslim 0 "No" 1 "Yes"
label values sunnimuslim ismuslim
label values shiamuslim ismuslim


*======================================================
* Outputs
*======================================================

set more off
log using "Tables S4 and S5. Sectarian Divide Among Respondents.log", replace
	
	tab COUNTRY mazhab, row
	tab COUNTRY sunnimuslim if mazhab==2, row
	tab COUNTRY shiamuslim if mazhab==1, row

log close
